function path = getkWavePath(folder_name)
%GETKWAVEPATH   Return pathname to the k-Wave Toolbox.
%
% DESCRIPTION:
%       getkWavePath returns the full directory pathname to the root
%       directory in the k-Wave Toolbox using the slash direction native to
%       the users operating system. If a folder_name string is provided,
%       this is appended to the pathname.
%
% USAGE:
%       path = getkWavePath()
%       path = getkWavePath(folder_name)
%
% OPTIONAL INPUTS:
%       folder_name - folder name string to append to the pathname
%
%       Note: folder_name is not checked for existance, the string is
%       simply appended to the pathname with a trailing slash.
%
% OUTPUTS:
%       path        - full pathname to the root directory in the k-Wave
%                     Toolbox 
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 30th June 2009
%       last update - 17th July 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)

% get the full pathath of the 
path = mfilename('fullpath');

% trim off the m-file name
path = path(1:end-12);

% apathpathend folder name if given
if nargin ~= 0
    % extract required slash
    slash = path(end);
    
    % apathpathend folder name
    path = [path folder_name slash];
end

